IF EXISTS (SELECT * FROM sys.objects 
				WHERE object_id = OBJECT_ID('[dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_JOIN_NF_EST_PED_CP]') AND
						type IN ( 'P', 'PC' ))
	DROP PROCEDURE [dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_JOIN_NF_EST_PED_CP]

GO

CREATE PROCEDURE P_EST_NF_ENT_DANFE_PROVISORIO_JOIN_NF_EST_PED_CP
as
 
	SET NOCOUNT on;
	set CONTEXT_INFO 0x99999;
------------------------------------------------------------------------------------------------
	SELECT 
		a.cd_ctr,
		a.cd_filial,
		a.cd_forn,
		a.cd_ped_forn   collate SQL_Latin1_General_CP1_CI_AS as cd_ped_forn
		INTO #TmpCdCtr 
	FROM 
		est_nf_ent_danfe_provisorio  a
		join est_nf_ent_danfe_provisorio_pendente  b on 
		a.cd_ctr = b.cd_ctr
		left join est_nf_ent_danfe_provisorio_est_ped_Cp c on 
		a.cd_ctr = c.cd_ctr
	WHERE 
		c.cd_emp IS null;
------------------------------------------------------------------------------------------------
	SELECT 
		DISTINCT
		i.cd_Ctr,
		0 Qtd_Xped,
		i.xped_it Xped,
		t.cd_filial,
		t.cd_forn,
		0 Cd_ped,
		0 Cd_PedNovo,
		t.cd_ped_forn 
		INTO #TmpXped 
	FROM 
		est_nf_ent_danfe_provisorio_itens  i
		join #TmpCdCtr t ON 
		i.cd_ctr = T.cd_ctr;

	delete from #TmpXped where len(xped) =0;
	delete FROM #TmpXped where isnumeric(xped)=0;
	DELETE FROM #TmpXped  where not convert(money,Xped)>0;

	IF  NOT exists(SELECT * FROM #TmpXped)
	BEGIN
		PRINT 'Nenhum danfe com pedido diferente. Line 51' 
		return;
	END 

	;With QtdXped as(select 
						Cd_ctr,
						count(DISTINCT Xped) Qtd 
					from 
						#TmpXped 
					GROUP BY cd_Ctr) 
	UPDATE t
	set Qtd_Xped= qt.Qtd
	from 
	#TmpXped  t
	join QtdXped  qt on 
	t.cd_ctr =qt.cd_Ctr;


	DELETE FROM #TmpXped WHERE qtd_xped <2;
--------------------------------------------------------------------------------------------
	IF  NOT exists(SELECT * FROM #TmpXped)
	BEGIN
		PRINT 'Nenhum danfe com pedido diferente. Line 74'
		return;
	END

	delete from a 
		from #TmpCdCtr a 
		left join #TmpXped  b on 
		a.cd_ctr =b.cd_ctr
		where b.cd_ctr is null
--------------------------------------------------------------------------------------------
--Relaciona os produtos referente ao que chegou no danfe para gerar pedidos de compra
	SELECT
		c.cd_ctr, 
		c.cd_filial,
		c.cd_forn,
		d.cd_prod,
		d.cd_ctr_it,
		d.qtde_prod
		INTO #TmpPedDanfe
	from 
		#TmpCdCtr c
		join (SELECT D.CD_CTR 
					,D.CD_PROD
					,ROW_NUMBER() OVER (partition BY D.CD_CTR ORDER BY D.CD_CTR, D.CD_PROD ) CD_CTR_IT
					,SUM (D.QTDE_PROD * ( D.APRES_QT_CP * CASE WHEN ISNULL(D.APRES_EMB_CP, 0) = 0 THEN 1 
																ELSE D.APRES_EMB_CP END )) QTDE_PROD
				FROM
					#TmpXped t	
					join est_nf_ent_danfe_provisorio_itens d on 
					d.cd_ctr	= T.cd_ctr and
					d.xped_it   = t.xped

				GROUP  BY
					 D.CD_CTR
					,D.CD_PROD) D ON
		c.CD_CTR = D.CD_CTR;
--------------------------------------------------------------------------------------------
--Relaciona os produtos referente ao foi feito pedido.. 
	select 
		t.cd_ctr,
		p.cd_filial,
		p.cd_ped,
		p.cd_ped_forn,
		0 cd_pedNovo,
		i.cd_prod,
		sum(I.QT_IT_SLD) qt_it,
		convert(money, 0.00) qt_pedir,
		0 CdCtrIt 
		into #TmpPedCompra 
	from
		est_ped_cp p
		join #TmpXped t ON 
		p.cd_filial		= t.cd_filial AND
		p.cd_forn		= t.cd_forn and 
		p.cd_ped_forn collate SQL_Latin1_General_CP1_CI_AS= t.xped
	
		join est_ped_cp_it i on 
		p.cd_filial	= i.cd_filial AND
		p.cd_ped	= i.cd_ped and
		p.cd_emp    = i.cd_emp
		----nao relacionar pedidos j vinculados
		--left join est_nf_ent_danfe_provisorio_est_ped_Cp dp on 
		--p.cd_emp = dp.cd_emp and
		--p.cd_ped = dp.cd_ped and
		--p.cd_filial = dp.cd_filial
	where
		p.cd_emp =1
		--and dp.CD_EMP is null
		and p.sts_ped <> 2 
	group by 	
		t.cd_ctr,
		p.cd_ped,
		p.cd_ped_forn,
		p.cd_filial,
		i.cd_prod
	
	Delete from #TmpPedCompra where qt_it <=0;
		 
--------------------------------------------------------------------------------------------
	update t
	set
		cd_ped= p.cd_ped 
	from 
		#TmpPedCompra p
		join #TmpXped t ON 
		p.cd_filial	= t.cd_filial AND
		p.cd_ctr	= t.cd_ctr and 
		p.cd_ped_forn collate SQL_Latin1_General_CP1_CI_AS = t.xped;
		 
--------------------------------------------------------------------------------------------
--Faz a conferencia de Danfe X pedido para gerar o novo pedido de apenas os itens que chegaram no Danfe, mas respeitando a quantidade pedida
	Update c
	set
		qt_pedir = case when d.qtde_prod > c.qt_it then c.qt_it
						else d.qtde_prod end,
		CdCtrIt = cd_ctr_it
	from 
		#TmpPedDanfe d
		join #TmpPedCompra  c on 
		d.cd_ctr = c.cd_ctr and 
		d.cd_prod = c.cd_prod;	
--------------------------------------------------------------------------------------------
--Gerar o Codigo do novo pedido...

	UPDATE P
	SET    Cd_pednovo = Ped_novo
	FROM   
		#TmpXped P
		INNER JOIN (SELECT
						v.CD_FILIAL
						,v.CD_PED
						,V.CD_CTR 
						, ISNULL(ULT_PED, 0)
						+ DENSE_RANK() OVER (ORDER BY v.CD_FILIAL, v.CD_CTR) PED_NOVO
					FROM
						#TmpXped v
						LEFT JOIN (SELECT CD_EMP ,CD_FILIAL,MAX(CD_PED) ULT_PED
										FROM EST_PED_CP WHERE CD_EMP=1 
										GROUP  BY CD_EMP ,CD_FILIAL) m ON
						v.CD_FILIAL = m.CD_FILIAL) N ON
		P.CD_PED	= N.CD_PED  AND
		P.CD_CTR	= N.CD_CTR  AND
		P.CD_FILIAL	= N.CD_FILIAL;
	
	Update t
	SET    Cd_pednovo = p.Cd_pednovo
	FROM   
		#TmpXped P
		JOIN #TmpPedCompra t on  
		P.CD_FILIAL	= t.CD_FILIAL  AND
		P.CD_CTR	= t.CD_CTR ;			
	
	delete from a
	From 	 
		#TmpXped a
		left join #TmpPedCompra b on 
		a.cd_ped	= b.cd_ped  and
		a.cd_filial	= b.cd_filial  and
		a.cd_ctr	= b.cd_ctr
	where
		b.cd_ped is null;	

	delete from #TmpPedCompra where cd_pedNovo=0 or qt_Pedir <=0;
	delete from #TmpXped where cd_pedNovo=0 or cd_ped=0 ;
--------------------------------------------------------------------------------------------
--Grava EST_PED_CP
	
	PRINT 'Geracao de pedidos de compras. Line 196 - ' + CONVERT(VARCHAR, GETDATE(), 108);
	begin try
		 begin tran;

		 INSERT INTO EST_PED_CP (CD_EMP, CD_FILIAL, CD_PED, CD_FORN, DT_EMI, VLR_PED, VLR_TOT_PROD,
										 VLR_DESC, DT_PREV_ENT, VLR_ENCG_FIN, PERC_ICMS_ENCG_FIN, VLR_ICMS, VLR_IPI,
										 VLR_BASE_SUBS, VLR_ICMS_SUBS, CD_NT_MOV, STS_PED, VLR_BASE_ICMS, CD_USU,DT_CAD,
										 DT_ULT_ATU,DT_BAIXA, VLR_FRETE, NF_IPI_BASE_CALC, ENCG_TRIB, NAO_CONSTAR_PEND_ENTR,
										 DT_CANCEL, CD_USU_CANCEL, NR_REQ_FORN,TP_FRETE,CONHECIMENTO, CALC_SUBS_PMC, 
										 PERC_REDU_SUBS_PMC, DT_PREV_ENT_ANT,CD_PED_FORN,CD_TIPO_FATURAMENTO,HORA_PREV_ENT,
										 QT_VOL,FLAG_GERAR_CROSS,CD_COND_PGTO,CD_CTR_DANFE,ORIGEM_PED,APLICATIVO,VERSAO_APLICATIVO,
										 DT_FATURAMENTO)
			SELECT
					P.CD_EMP
				, P.CD_FILIAL
				, V.CD_PEDNOVO   CD_PED
				, V.CD_FORN		CD_FORN
				, convert(date, getdate()) DT_EMI
				, 0 VLR_PED
				, 0 VLR_TOT_PROD
				, 0 VLR_DESC
				, convert(date, getdate()) DT_PREV_ENT
				, 0 VLR_ENCG_FIN
				, 0 PERC_ICMS_ENCG_FIN
				, 0 VLR_ICMS
				, 0 VLR_IPI
				, 0 VLR_BASE_SUBS
				, 0 VLR_ICMS_SUBS
				, max(CD_NT_MOV) CD_NT_MOV
				, 0 STS_PED
				, 0 VLR_BASE_ICMS
				, 1 CD_USU
				, GETDATE()            DT_CAD
				, null DT_ULT_ATU
				, null DT_BAIXA
				, sum(VLR_FRETE) VLR_FRETE
				, 0 NF_IPI_BASE_CALC
				, 0 ENCG_TRIB
				, 0 NAO_CONSTAR_PEND_ENTR
				, null DT_CANCEL
				, 0 CD_USU_CANCEL
				, 0 NR_REQ_FORN
				, max(TP_FRETE) TP_FRETE
				, max(CONHECIMENTO)  CONHECIMENTO
				, max(CALC_SUBS_PMC) CALC_SUBS_PMC
				, avg(PERC_REDU_SUBS_PMC) PERC_REDU_SUBS_PMC
				, null DT_PREV_ENT_ANT
				, convert (varchar(12), V.CD_CTR) CD_PED_FORN
				, max(CD_TIPO_FATURAMENTO) CD_TIPO_FATURAMENTO
				, getdate() HORA_PREV_ENT
				, sum(QT_VOL) QT_VOL
				, 0 FLAG_GERAR_CROSS
				, max(CD_COND_PGTO)
				, V.CD_CTR _DANFE
				, 1 ORIGEM_PED
				, 'p_est_nf_ent_danfe_provisorio_join_nf_est_ped_cp' APLICATIVO
				, '1.0' VERSAO_APLICATIVO
				, max(DT_FATURAMENTO) DT_FATURAMENTO
			FROM
				EST_PED_CP P
				INNER JOIN #TmpXped V ON 
					P.CD_FILIAL = V.CD_FILIAL AND
					P.CD_PED	= V.CD_PED
			where p.cd_emp=1
			group by 
					P.CD_EMP
				, P.CD_FILIAL
				, v.cd_ped_forn
				, v.cd_ctr
				, V.CD_PEDNOVO 
				, V.CD_FORN	;

			--Atualiza o cd_ped_forn, para nao vincular com outro pedido..
			UPDATE V 
			SET
				cd_ped_forn  = convert (varchar(12), V.CD_CTR)
			FROM
				EST_NF_ENT_DANFE_PROVISORIO  D
				INNER JOIN #TmpXped V ON 
					D.CD_CTR = V.CD_CTR;

--------------------------------------------------------------------------------------------
--Grava  EST_PED_CP_IT
		PRINT 'Gravacao dos itens de pedidos. Line 270 - ' + CONVERT(VARCHAR, GETDATE(), 108);

		INSERT INTO EST_PED_CP_IT (CD_EMP, CD_FILIAL, CD_PED, CD_PROD, SEQ_ITEM, VLR_IT,
										QT_IT,CD_TRIB,PERC_IPI, VLR_CUSTO,VLR_BASE_SUBS,VLR_ICMS_SUBS,
										ALIQ_ICMS, VLR_BASE_ICMS,CD_NT_OP,VLR_IPI,
										VLR_ICMS, PERC_DESC, VLR_DESC, PERC_IVA, QT_EMB, PERC_IPI_CUSTO,
										PERC_DESC_FINAN,CD_COND_COMPRA, XPED_IT)
		
	
		SELECT
			 I.CD_EMP
			, I.CD_FILIAL
			, t.CD_PEDNOVO                                    CD_PED
			, I.CD_PROD
			, row_number() over (partition by i.cd_filial, t.cd_pedNovo order by i.cd_filial, t.cd_pedNovo) Seq_item
			, AVG(I.VLR_IT) VLR_IT
			, 
			sum(CASE WHEN t.Qt_Pedir > ( I.QT_IT * CASE WHEN ISNULL(I.QT_EMB,0)=0 THEN 1 ELSE I.QT_EMB END ) THEN I.QT_IT
				ELSE ROUND(t.Qt_Pedir/ CASE WHEN ISNULL(I.QT_EMB,0)=0 THEN 1 ELSE I.QT_EMB END, 0)
				END)                                              QT_IT
			, max(I.CD_TRIB)	CD_TRIB
			, avg(I.PERC_IPI)	PERC_IPI
			, avg(I.VLR_CUSTO)	VLR_CUSTO
			, avg(I.VLR_BASE_SUBS) VLR_BASE_SUBS
			, avg(I.VLR_ICMS_SUBS) VLR_ICMS_SUBS
			, avg(I.ALIQ_ICMS) ALIQ_ICMS
			, avg(I.VLR_BASE_ICMS) VLR_BASE_ICMS
			, max(I.CD_NT_OP) CD_NT_OP
			, avg(I.VLR_IPI) VLR_IPI
			, avg(I.VLR_ICMS) VLR_ICMS
			, avg(I.PERC_DESC) PERC_DESC

			, sum(( CASE WHEN t.Qt_Pedir > ( I.QT_IT * I.QT_EMB ) THEN I.QT_IT
		 			ELSE ROUND(t.Qt_Pedir / ISNULL(I.QT_EMB,0), 0)
		 			END * I.VLR_IT ) * (( I.PERC_DESC / 100.000 ))) VLR_DESC

			, avg(I.PERC_IVA) PERC_IVA
			, max(I.QT_EMB)  QT_EMB 
			, avg(I.PERC_IPI_CUSTO) PERC_IPI_CUSTO
			, avg(I.PERC_DESC_FINAN) PERC_DESC_FINAN
			, avg(I.CD_COND_COMPRA) CD_COND_COMPRA
			, max(X.XPED)
		FROM
			EST_PED_CP_IT I
			Join #TmpXped x on 
			I.CD_FILIAL = x.CD_FILIAL  AND
			I.CD_PED	= x.CD_PED

			INNER JOIN #TmpPedCompra T ON
			I.CD_FILIAL = t.CD_FILIAL  AND
			I.CD_PROD	= t.CD_PROD		
			
			AND x.CD_CTR = t.CD_CTR
		where
			I.CD_EMP	= 1		
		group by i.CD_EMP
			, I.CD_FILIAL
			, t.CD_PEDNOVO                                    
			, I.CD_PROD ;
			  
--------------------------------------------------------------------------------------------
--Alterar o total dos pedidos gerados 
		PRINT 'Totalizando os pedidos gerados. Line 332 ' + CONVERT(VARCHAR, GETDATE(), 108);

		UPDATE p
		SET     
			VLR_TOT_PROD = T.TOT_PROD,
			VLR_IPI = T.VLR_IPI,
			VLR_BASE_ICMS = T.VLR_BASE_ICMS,
			VLR_ICMS = T.VLR_ICMS,
			VLR_BASE_SUBS = T.VLR_BASE_SUBS,
			VLR_ICMS_SUBS = T.VLR_ICMS_SUBS,
			VLR_DESC = T.VLR_DESC,
			VLR_PED = ( T.TOT_PROD + T.VLR_IPI + T.VLR_ICMS_SUBS
									+ P.VLR_FRETE )
		FROM   
			EST_PED_CP P
			INNER JOIN (SELECT
								I.CD_EMP
								,I.CD_FILIAL
								,I.CD_PED
								,SUM (( I.QT_IT * I.VLR_IT ) - I.VLR_DESC) AS TOT_PROD
								,SUM (I.VLR_DESC)                          AS VLR_DESC
								,SUM (I.VLR_BASE_ICMS)                     AS VLR_BASE_ICMS
								,SUM (I.VLR_ICMS)                          AS VLR_ICMS
								,SUM (I.VLR_BASE_SUBS)                     AS VLR_BASE_SUBS
								,SUM (I.VLR_ICMS_SUBS)                     AS VLR_ICMS_SUBS
								,SUM (I.VLR_IPI)                           AS VLR_IPI
							FROM
								#TmpPedCompra v
								INNER JOIN EST_PED_CP_IT I ON 
									V.CD_FILIAL		= I.CD_FILIAL AND
									V.CD_PEDNOVO	= I.CD_PED
							where
								I.CD_EMP =1
							GROUP  BY
								I.CD_EMP
								,I.CD_FILIAL
								,I.CD_PED) T ON
				P.CD_EMP = T.CD_EMP AND
				P.CD_FILIAL = T.CD_FILIAL AND
				P.CD_PED = T.CD_PED;

--------------------------------------------------------------------------------------------
--Realiza vinculo com pedido

		INSERT INTO EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP (CD_CTR, CD_EMP, CD_FILIAL, CD_PED, CD_USU,DT_CAD)
		SELECT distinct 
			 x.CD_CTR
			,1 CD_EMP
			,x.CD_FILIAL
			,x.CD_PEDNOVO CD_PED
			,1 CD_USU
			,getdate() DT_CAD
		from 
			#TmpXped x
			join EST_PED_CP a on 		
			x.CD_FILIAL		= A.CD_FILIAL and
			x.cd_pednovo	= A.CD_PED 
		WHERE A.CD_EMP=1

		update a 
		set
			CD_PED_FORN= CD_PEDNOVO
		FROM
			EST_NF_ENT_DANFE_PROVISORIO a
			join #TmpXped b on a.cd_ctr = b.cd_ctr
			join EST_PED_CP c on 
							B.CD_FILIAL		= c.CD_FILIAL and
							B.cd_pednovo	= c.CD_PED  
		where	a.cd_emp=1;
		
 --------------------------------------------------------------------------------------------
 --Criar o vinculo com o novo pedido

		PRINT 'Cria o vinculo com o novo pedido. Line 397 - ' + CONVERT(VARCHAR, GETDATE(), 108); 
		INSERT INTO EST_PED_CP_PED_CP_FORN_VINCULADO
							(CD_EMP,CD_FILIAL,CD_PED
								,CD_PED_VINC--Cod do novo pedido
								,CD_USU,DT_CAD ,CD_CTR_DANFE)
		SELECT distinct 
			 1 CD_EMP
			,X.CD_FILIAL
			,X.CD_PED
			,X.CD_PEDNOVO   CD_PED_VINC
			,1 CD_USU
			,GETDATE() DT_CAD
			,X.CD_CTR 
		from 
			#TmpXped  X
			join EST_PED_CP a on 			
			x.CD_FILIAL		= A.CD_FILIAL and
			x.cd_pednovo	= A.CD_PED 
		WHERE A.CD_EMP=1

------------------------------------------------------------------------------------------------------------------------------
		--Cancela o saldo gerado pelo novo pedido
		 

		INSERT INTO EST_PED_CP_IT_CANCEL_SLD (CD_EMP,CD_FILIAL, CD_PED,CD_PROD, CD_USU,QT_PROD,DT_CANCEL, HIST, DT_HR_CANCEL)
		SELECT
			  I.CD_EMP
			, I.CD_FILIAL
			, X.CD_PED               CD_PED
			, I.CD_PROD
			, 1 CD_USU
			--, sum(CASE WHEN v.Qt_Pedir > ( I.QT_IT * CASE WHEN ISNULL(I.QT_EMB,0)=0 THEN 1 ELSE I.QT_EMB END ) THEN I.QT_IT
			--	ELSE ROUND(v.Qt_Pedir/ CASE WHEN ISNULL(I.QT_EMB,0)=0 THEN 1 ELSE I.QT_EMB END, 0)
			--	END)  
			, sum (I.QT_IT) --Cancelar todos os itens para nao ficar saldo pendente sem nf vinculada - Sol. Glaucimar
			, GETDATE()              DT_CANCEL
			,'P_EST_NF_ENT_DANFE_PROVISORIO_JOIN_NF_EST_PED_CP'
			, GETDATE()              DT_CANCEL
		FROM
			EST_PED_CP_IT I
			JOIN #TmpXped X ON
			I.CD_FILIAL = X.CD_FILIAL	and 			
			I.CD_PED	= X.CD_PED  

			INNER JOIN #TmpPedCompra V ON
				I.CD_FILIAL = v.CD_FILIAL  AND
				I.CD_PROD	= v.CD_PROD	 AND 
				x.CD_CTR	= v.CD_CTR
			
			LEFT JOIN EST_PED_CP_IT_CANCEL_SLD s ON
				I.CD_EMP	= s.CD_EMP AND
				I.CD_FILIAL = s.CD_FILIAL AND
				I.CD_PED	= S.CD_PED AND
				I.CD_PROD	= S.CD_PROD
		WHERE
			i.cd_emp=1
			and S.CD_EMP IS NULL
		group by 
			I.CD_EMP
			, I.CD_FILIAL
			, X.CD_PED
			, I.CD_PROD;
			 
------------------------------------------------------------------------------------------------------------------------------
--Atualiza o status dos pedidos 

		PRINT 'Atualiza o status dos pedidos antigos. Line 456 - ' + CONVERT(VARCHAR, GETDATE(), 108);
		UPDATE P
		SET    P.STS_PED = C.STS
		FROM   
			EST_PED_CP p
			INNER JOIN (SELECT
								V.CD_FILIAL
							,V.CD_PED
							,CASE	WHEN dbo.TST_EST_PED_CP_STATUS (1, V.CD_FILIAL, V.CD_PED) IN ( 'PEDIDO CANCELADO', 'CANCELADO' ) THEN 2
									WHEN dbo.TST_EST_PED_CP_STATUS (1, V.CD_FILIAL, V.CD_PED) IN ( 'PEDIDO COM ENTREGA TOTAL' ) THEN 3
									ELSE 0 END STS
						FROM
							#TmpXped v) C ON
			P.CD_FILIAL = C.CD_FILIAL AND
			P.CD_PED	= C.CD_PED
		WHERE
			p.cd_emp=1
			and p.STS_PED > 0;
		commit tran;
	end try
	begin catch
			rollback tran;
			PRINT 'Falha ao tentar criar/vincular pedido de compras. Line 478'
			PRINT ERROR_MESSAGE();
 
			--RETURN;
	end catch
------------------------------------------------------------------------------------------------------------------------------
 
/************************************************

select * from #TmpCdCtr
select * from #TmpPedDanfe
select * from #TmpXped
select * from #TmpPedCompra 

select	distinct cd_ctr, cd_filial, cd_forn , cd_pednovo  from #TmpXped 

************************************************/